package gov.va.vinci.dart.json.builder;

import java.util.ArrayList;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.json.PersonListView;
import gov.va.vinci.dart.json.PersonView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestPersonListViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		PersonListViewBuilder builder = SingletonShim.getBean(PersonListViewBuilder.class);
		
		try {
			builder.build((List<Person>)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		List<Person> personList = new ArrayList<Person>();
		
		PersonListView plv = builder.build(personList);
		Assert.assertNotNull(plv);
		Assert.assertNotNull(plv.getPersons());
		Assert.assertEquals(plv.getPersons().size(), 0);

		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1004);

		personList.add(pers);
		
		plv = builder.build(personList);
		Assert.assertNotNull(plv);
		Assert.assertNotNull(plv.getPersons());
		Assert.assertEquals(plv.getPersons().size(), 1);
		
		PersonView pdv = plv.getPersons().get(0);
		Assert.assertNotNull(pdv);
		Assert.assertEquals(pdv.getId(), 1004);
		Assert.assertEquals(pdv.getName(), pers.getName());
		Assert.assertEquals(pdv.getDescription(), pers.getDescription());
		Assert.assertEquals(pdv.getFullName(), pers.getFullName());
		Assert.assertEquals(pdv.getLocationId(), pers.getLocation().getId());
	}
	
}
